; Diagnostic ROM part 7
; Test 6 64 RAM in -003 
; Author Dwight Elvey
;
; Converted to standard assembler Hans Otten, 2025
;
; Standard Defines KIM-1
;
; I/O in 6530-002
;
SAD     =     $1740             ; 6530 A DATA
PADD    =     $1741             ; 6530 A DATA DIRECTION
SBD     =     $1742             ; 6530 B DATA
PBDD    =     $1743             ; 6530 B DATA DIRECTION
CLK1T   =     $1744             ; DIV BY 1 TIME
CLK8T   =     $1745             ; DIV BY 8 TIME
CLK64T  =     $1746             ; DIV BY 64 TIME
CLKKT   =     $1747             ; DIV BY 1024 TIME
CLKRDI  =     $1747             ; READ TIME OUT BIT
CLKRDT  =     $1746             ; READ TIME
;
;
; I/O in 6530-002
;
SAD1     =     $1700             ; 6530 A DATA
PADD1    =     $1701             ; 6530 A DATA DIRECTION
SBD1     =     $1702             ; 6530 B DATA
PBDD1    =     $1703             ; 6530 B DATA DIRECTION
CLK1T1   =     $1704             ; DIV BY 1 TIME
CLK8T1   =     $1705             ; DIV BY 8 TIME
CLK64T1  =     $1706             ; DIV BY 64 TIME
CLKKT1   =     $1707             ; DIV BY 1024 TIME
CLKRDI1  =     $1707             ; READ TIME OUT BIT
CLKRDT1  =     $1706             ; READ TIME

; Zero page 6530--002
;
;
TEMP	= 	  $F8
INH     =     $F9               ; INPUT BUFFER
POINTL  =     $FA               ; LSB OF OPEN CELL
POINTH  =     $FB               ; MSB OF OPEN CELL
CNT		=	  $FC				; counter
;
; KIM-1 Routines
;
SCANDS  = $1F1F
KEYIN   = $1F40
GETKEY  = $1F6A

;Test 7 64RAM3
; Switch setting:
;  DB on
;  --
;  S0 off
;  S1 off
;  S2 off
;  S3 on
;This test the 64 bits of RAM in the -003 6530 chip. It uses the
;March C algorythm. This is a good test. If it passes, it says
;'Good'. If it fails it says 'Bad nn' Where the nn indicates the
;bad address. Say it displayed 'Bad 92'. That would indicate thath the
;address 1700 + 92 = 1792 failed. Make sure to start the test from a 
;clean reset by pushing the RS when changing the debug switches or
;when powering up.
; TEST FOR THE 64 BYTES IN -003
; If passes it displays 'Good'
; If a failure, it displays 'Bad nn' where nn is the last two digits
;  of the address of failure. Example if nn = C5 the failed address is
; 17C5. -002's RAM is 17C0 to 17FF.
; This uses the March C algorithm.
; It stops on first failure. The first test is up going so a failure
; of 17C0h may mean that the entire 64 bytes are not being accessed.
; Other addresses could be single or multiple failures

	.ORG $0C00
GOOD		  .BYTE $DE, $DC,$DC, $BD, 
BAD			  .BYTE $00,$DE, $F7, $FC
		  
SETUPDISP
          LDX #$09
          STX $1742
          LDA #$1F
          STA $1743
          LDA #$00
          STA $1740
          LDA #$7F
          STA $1741
          RTS
LOOP		  
          JSR SETUPDISP
PASS1     LDX #$09
          STX $1742
          LDY #$04
L1C27     LDA #$00
          STA $1740
          LDA GOOD-1,Y
          STX $1742
          STA $1740
          TYA
          LDY #$80
L1C38     NOP
          NOP
          NOP
          NOP
          DEY
          BNE L1C38
          INX
          INX
          TAY
          DEY
          BNE L1C27
          BEQ PASS1
;
ERROR		  
          TXA
          CLC
          BMI L1C50
          ADC #$C0
          JMP LERR
		  
L1C50     ADC #$80
LERR      STA $00
LOOPERR   JSR $0C08
          LDY #$04
L1C59     LDA BAD-1,Y
          STX $1742
          STA $1740
          TYA
          LDY #$60
L1C65     STA BAD,X
          DEY
          BNE L1C65
          INX
          INX
          TAY
          DEY
          BNE L1C59
          LDA $00
          LSR A
          LSR A
          LSR A
          LSR A
          AND #$0F
          TAY
          LDA $1FE7,Y
          STX $1742
          STA $1740
          LDY $60
L1C85     STA $0C04,X
          DEY
          BNE L1C85
          INX
          INX
          LDA $00
          AND #$0F
          TAY
          LDA $1FE7,Y
          STX $1742
          STA $1740
          LDY $60
L1C9D     STA $0C04,X
          DEY
          BNE L1C9D
          BEQ LOOPERR
RESET		  
          CLD
          LDX #$40
          LDA #$55
L1CAA     STA $177F,X
          DEX
          BNE L1CAA
          LDX #$C0
L1CB2     LDA #$55
          CMP $16C0,X
          BEQ L1CBC
          JMP ERROR
L1CBC     LDA #$AA
          STA $16C0,X
          INX
          BNE L1CB2
          LDX #$C0
L1CC6     LDA #$AA
          CMP $16C0,X
          BEQ L1CD0
          JMP ERROR
L1CD0     LDA #$55
          STA $16C0,X
          INX
          BNE L1CC6
          LDX #$40
L1CDA     CMP $177F,X
          BEQ L1CE2
          JMP ERROR
L1CE2     DEX
          BNE L1CDA
          LDX #$40
L1CE7     LDA #$55
          CMP $177F,X
          BEQ L1CF1
          JMP ERROR
L1CF1     LDA #$AA
          STA $177F,X
          DEX
          BNE L1CE7
          LDX #$40
          NOP
          NOP
          NOP
          NOP
          NOP
L1D00     LDA #$AA
          CMP $177F,X
          BEQ L1D0A
          JMP ERROR
L1D0A     LDA #$55
          STA $177F,X
          DEX
          BNE L1D00
          LDX #$40
L1D14     CMP $177F,X
          BEQ L1D1C
          JMP ERROR
L1D1C     DEX
          BNE L1D14
          JMP LOOP
;
HEREV
		.FILL (VECTOR - HEREV)&$FFF, 0
		  .ORG $FFFA
VECTOR		  


;
; Reset vectors
;	


          .BYTE RESET&255
          .BYTE RESET/256
          .BYTE RESET&255
          .BYTE RESET/256
          .BYTE RESET&255
          .BYTE RESET/256
		 .END